package tdsync;

import junit.framework.TestCase;
import td2jira.Config;
import td2jira.jira.IJIRAConnector;
import td2jira.jira.xmlrpc.JIRAXmlRpcConnector;
import td2jira.td.api.ConnectionFactory;
import td2jira.td.api.IBug;
import td2jira.td.api.IConnection;
import td2jira.td.api.IFactory;
import td2jira.td.api.IFactoryList;
import td2jira.td.api.IFilter;
import td2jira.td.api.dcom.Factory;

public class TestLogin extends TestCase {

	IFactoryList fl;

	public void setUp() throws Exception {
		Config.load();
	}
	
	public void tearDown() throws Exception {
		if( fl != null ) fl.safeRelease();
	}
	
	public void testVoid(){}
	
	public void testLogin() throws Exception {
		IConnection td = ConnectionFactory.getInstance(
				Config.TD_URL,
				Config.TD_DOMAIN,
				Config.TD_PROJECT, 
				Config.TD_USER,
				Config.TD_PASSWORD);

		IJIRAConnector jc = new JIRAXmlRpcConnector();
		
		IFactory bf = td.getBugFactory();
		System.out.println(bf);
		
		IFilter filter = bf.getFilter();
		System.out.println(filter);
		
		fl = filter.getNewList();
		System.out.println(fl);
		
		System.out.println("bugs:"+fl.getCount());
		
		for( int i=1; i<fl.getCount(); ++i ) {
			IBug bug = fl.getBug(i);
			if( !bug.getId().equals("618") ) continue;
			
			System.out.println(bug.getId());
			System.out.println(" "+bug.getStatus());
			System.out.println(" "+bug.getSummary());
			System.out.println(" assigned to: "+bug.getAssignedTo());
			System.out.println(" severity: "+bug.getSeverity());

			String[] bgs = new String[]{
					"BG_ACTUAL_FIX_TIME",
					"BG_BUG_VER_STAMP",
					"BG_CLOSING_DATE",
					"BG_CLOSING_VERSION",
					"BG_CYCLE_ID",
					"BG_CYCLE_REFERENCE",
					"BG_DESCRIPTION",
					"BG_DETECTED_BY",
					"BG_DETECTION_DATE",
					"BG_DETECTION_VERSION",
					"BG_DEV_COMMENTS",
					"BG_ESTIMATED_FIX_TIME",
					"BG_EXTENDED_REFERENCE",
					"BG_HAS_CHANGE",
					"BG_PLANNED_CLOSING_VER",
					"BG_PRIORITY",
					"BG_PROJECT",
					"BG_REPRODUCIBLE",
					"BG_REQUEST_ID",
					"BG_REQUEST_NOTE",
					"BG_REQUEST_SERVER",
					"BG_REQUEST_TYPE",
					"BG_RESPONSIBLE",
					"BG_RUN_REFERENCE",
					"BG_SEVERITY",
					"BG_STATUS",
					"BG_STEP_REFERENCE",
					"BG_SUBJECT",
					"BG_SUMMARY",
					"BG_TEST_REFERENCE",
					"BG_TO_MAIL",
					"BG_USER_01",
					"BG_USER_02",
					"BG_USER_03",
					"BG_USER_04",
					"BG_VTS" };
								
//			for (String bg : bgs) {
//				 String field = bug.getFieldAsString(bg);
//				 if( field != null ) {
//					 System.out.print(bg+"\n    ");
//					 System.out.println(field);
//					 System.out.println();
//				 }
//			}
			
			System.out.println("has attachments: "+bug.hasAttachments());
			if( bug.hasAttachments() ) {
				System.out.println(bug.getAttachmentsNames());
			}
			
//			Factory attachments = bug.getAttachments();
//			FactoryList attachmentsList = attachments.getFilter().getNewList();
//			System.out.println(" attachments#:"+attachmentsList.getCount());
//			for( int n=1; n<attachmentsList.getCount(); ++n ) {
//				Dispatch item = attachmentsList.getItem(n);
//				// doesn't work :(
//				// System.out.println("  attachName:"+Dispatch.call(item,"GetName",1));
//			}
//			System.out.println();
			
			break;
		}
		
		td.disconnect();
	}	
}
