package td2jira.sync.impl;

import org.apache.log4j.Logger;

import td2jira.jira.IJIRAConnector;
import td2jira.jira.JIRAIssue;
import td2jira.sync.IssuePair;
import td2jira.sync.SyncUtils;
import td2jira.td.ITDConnector;
import td2jira.td.api.IBug;

public class SyncAttachments implements IProcessIssuePair {
	private static Logger logger = Logger.getLogger(SyncAttachments.class);
	IJIRAConnector jiraConnector;
	ITDConnector tdConnector;
	
	public void setJiraConnector(IJIRAConnector jiraConnector) {
		this.jiraConnector = jiraConnector;
	}

	public void setTdConnector(ITDConnector tdConnector) {
		this.tdConnector = tdConnector;
	}
	
	public ProcessingResult process(JIRAIssue jiraIssue,IBug tdIssue) throws Exception {
		if( jiraIssue == null || tdIssue == null ) return ProcessingResult.PROCESS_NEXT_RULE;
		
		// sync attachments is expensive, so skip closed/rejected issues
		if( "Closed".equals(jiraIssue.getStatus()) || 
				"Closed".equals(tdIssue.getStatus()) || 
				"Rejected".equals(tdIssue.getStatus()) ) return ProcessingResult.PROCESS_NEXT_RULE;
		
		IssuePair pair = new IssuePair();
		pair.setJiraIssue(jiraIssue);
		pair.setTdIssue(tdIssue);
		SyncUtils.syncAttachmentsToJIRA(tdConnector,jiraConnector,pair);
		
		return ProcessingResult.PROCESS_NEXT_RULE;
	}
}
