package td2jira.sync.impl;

import org.apache.log4j.Logger;

import td2jira.jira.IJIRAConnector;
import td2jira.jira.JIRAIssue;
import td2jira.sync.SyncUtils;
import td2jira.td.ITDConnector;
import td2jira.td.api.IBug;

public class RecreateJiraIssue implements IProcessIssuePair {
	public static Logger logger = Logger.getLogger(CreateJiraIssue.class);
	private IJIRAConnector jiraConnector;
	private ITDConnector tdConnector;
	
	public void setJiraConnector(IJIRAConnector jiraConnector) {
		this.jiraConnector = jiraConnector;
	}

	public void setTdConnector(ITDConnector tdConnector) {
		this.tdConnector = tdConnector;
	}

	public ProcessingResult process(JIRAIssue jiraIssue,IBug tdIssue) throws Exception {
		if( !jiraIssue.getStatus().equals("Closed") ) throw new IllegalArgumentException("JIRA task is not closed:"+jiraIssue.getKey());
    	
		JIRAIssue newJiraIssue = SyncUtils.createJiraIssue(jiraConnector,tdConnector,tdIssue);
		jiraConnector.addComment(newJiraIssue, "TD issue is reopened; old JIRA issue is "+jiraIssue.getKey());
		jiraConnector.addComment(jiraIssue, "TD issue is reopened; new JIRA issue is "+newJiraIssue.getKey());

		return ProcessingResult.PROCESS_NEXT_ISSUE;
	}
}
