package td2jira.sync.impl;

import org.apache.log4j.Logger;

import td2jira.jira.IJIRAConnector;
import td2jira.jira.JIRAIssue;
import td2jira.sync.SyncUtils;
import td2jira.td.ITDConnector;
import td2jira.td.api.IBug;

public class CreateJiraIssue implements IProcessIssuePair {
	public static Logger logger = Logger.getLogger(CreateJiraIssue.class);
	private IJIRAConnector jiraConnector;
	private ITDConnector tdConnector;
	
	public void setJiraConnector(IJIRAConnector jiraConnector) {
		this.jiraConnector = jiraConnector;
	}

	public void setTdConnector(ITDConnector tdConnector) {
		this.tdConnector = tdConnector;
	}

	public ProcessingResult process(JIRAIssue jiraIssue,IBug tdIssue) throws Exception {
		if( jiraIssue != null ) throw new IllegalArgumentException("JIRA task exist:"+jiraIssue.getKey());
    	SyncUtils.createJiraIssue(jiraConnector,tdConnector,tdIssue);
		return ProcessingResult.PROCESS_NEXT_ISSUE;
	}
}
