package td2jira.sync.impl;

import org.apache.log4j.Logger;

import td2jira.jira.IJIRAConnector;
import td2jira.jira.JIRAIssue;
import td2jira.td.ITDConnector;
import td2jira.td.api.IBug;

public class CloseJiraIssue implements IProcessIssuePair {
	private static Logger logger = Logger.getLogger(CloseJiraIssue.class);
	private IJIRAConnector jiraConnector;
	private ITDConnector tdConnector;
	
	public void setJiraConnector(IJIRAConnector jiraConnector) {
		this.jiraConnector = jiraConnector;
	}

	public void setTdConnector(ITDConnector tdConnector) {
		this.tdConnector = tdConnector;
	}

	public ProcessingResult process(JIRAIssue jiraIssue,IBug tdIssue) throws Exception {
		if( jiraIssue.getSummary().indexOf("(CLOSED@TD)") < 0 ) {
			logger.debug("JIRA issue "+jiraIssue.getKey()+" is NOT CLOSED and TD "+tdIssue.getId()+" is CLOSED; closing JIRA issue");
			jiraConnector.closeIssue(jiraIssue);
		}
		
		return ProcessingResult.PROCESS_NEXT_ISSUE;
	}

}
