package td2jira.sync.impl;

import org.apache.log4j.Logger;

import td2jira.Config;
import td2jira.jira.IJIRAConnector;
import td2jira.jira.JIRAIssue;
import td2jira.td.ITDConnector;
import td2jira.td.api.IBug;

public class AskToRetest implements IProcessIssuePair {
	private static Logger logger = Logger.getLogger(AskToRetest.class);
	private IJIRAConnector jiraConnector;
	private ITDConnector tdConnector;
	
	public void setJiraConnector(IJIRAConnector jiraConnector) {
		this.jiraConnector = jiraConnector;
	}

	public void setTdConnector(ITDConnector tdConnector) {
		this.tdConnector = tdConnector;
	}

	public ProcessingResult process(JIRAIssue jiraIssue,IBug tdIssue) throws Exception {
		if( Config.TD_LEAD == null ) throw new IllegalArgumentException("td.lead shall be set to QA lead user id"); 
		
		if( !Config.TD_LEAD.equals(tdIssue.getAssignedTo()) ) {
			String assignee = tdIssue.getAssignedTo();
			if( Config.getDevelopersNamesInTD().contains(assignee) ) {
				logger.debug(jiraIssue.getKey()+" is closed, TD "+tdIssue.getId()+" is fixed, assigning to "+Config.TD_LEAD+" for retest");
				tdConnector.assignTo(tdIssue,Config.TD_LEAD);
			}
		}
		
		return ProcessingResult.PROCESS_NEXT_ISSUE;
	}
}
