package td2jira.jira;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JIRAIssue implements Serializable {
    public static Map<String,String> statuses = new HashMap<String, String>();
    public static Map<String,String> resolutions = new HashMap<String, String>();
	
	private String projectId;
	private String id;
	private String key;
	private String status;
	private String summary;
	private String assignee;
	private String description;
	
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String jiraId) {
		this.key = jiraId;
	}
	public String getSummary() {
		return summary;
	}
	public void setSummary(String summary) {
		this.summary = summary;
	}
	public String getProjectId() {
		return projectId;
	}
	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	
	public static String getStatusId(String name) {
		Iterator<String> it = statuses.keySet().iterator();
		while( it.hasNext() ) {
			String id = it.next();
			if( statuses.get(id).equals(name) ) {
				return id;
			}
		}
		throw new IllegalArgumentException("unknown status name:"+name);
	}
	
	public static String getResolutionId(String name) {
		Iterator<String> it = resolutions.keySet().iterator();
		while( it.hasNext() ) {
			String id = it.next();
			if( resolutions.get(id).equals(name) ) {
				return id;
			}
		}
		throw new IllegalArgumentException("unknown status name:"+name);
	}	
	
	public static JIRAIssue fromMap(Map<String,Object> map) {
        JIRAIssue jt = new JIRAIssue();
        jt.setDescription((String) map.get("description"));
        jt.setSummary((String) map.get("summary"));
        jt.setProjectId((String) map.get("project"));
        jt.setKey((String) map.get("key"));
        jt.setId((String) map.get("id"));
        jt.setStatus(statuses.get((String) map.get("status")));
        jt.setAssignee((String) map.get("assignee"));
		return jt;
	}
	
	public String getAssignee() {
		return assignee;
	}
	public void setAssignee(String assignee) {
		this.assignee = assignee;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
}

/*
found:{
	created=2007-06-06 05:40:00.42, 
	summary=horizontal line not genereated, 
	attachmentNames=confluence-wysiwyg-bug6a.png, 
	type=1, 
	affectsVersions=[Ljava.lang.Object;@db4fa2, 
	status=10005, 
	updated=2007-06-07 02:12:38.91, 
	key=53146, 
	key=CONF-8652, 
	components=[Ljava.lang.Object;@491c4c,
 	fixVersions=[Ljava.lang.Object;@1e0f2f6, 
 	description=
 		When you insert a horizontal line (something like <hr>) using the WYSIWYG editor, 
 		and then right behind it an emoticon, the horizontal rule is not
 		displayed correctly. Instead, the four hyphens and the emoticon are shown 
 		on one line. See attachments. 
*/
            

