package td2jira.jira;

import java.io.Serializable;

import td2jira.td.api.Comment;

public class JIRAComment implements Serializable {
	private String id;
	private String author;
	private String authorFullName;
	private String created; 
	private String body;
	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public String getBody() {
		return body;
	}
	public void setBody(String body) {
		this.body = body;
	}
	public String getCreated() {
		return created;
	}
	public void setCreated(String date) {
		this.created = date;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public static String format(Comment c) {
		StringBuilder sb = new StringBuilder("@TD");
		if( c.getAuthor().length() > 0 ) sb.append(' ').append(c.getAuthor());
		if( c.getCreated().length() > 0 ) sb.append(' ').append(c.getCreated());

		if( c.getBody().length() > 0 ) sb.append('\n').append(c.getBody());

		String body = sb.toString();
		body = body.replaceAll("&amp;", "&");
		body = body.replaceAll("&lt;", "<");
		body = body.replaceAll("&gt;", ">");
		body = body.replaceAll("&quot;","'");
		
		return body;
	}
	public static JIRAComment fromTDComment(Comment tdc) {
		JIRAComment d = new JIRAComment();
		d.setAuthor(tdc.getAuthor());
		d.setCreated(tdc.getCreated());
		d.setBody(tdc.getBody());
		return d;
	}
	public String getAuthorFullName() {
		return authorFullName;
	}
	public void setAuthorFullName(String authorFullName) {
		this.authorFullName = authorFullName;
	}
}
