package td2jira.jira;

import java.util.List;
import java.util.Map;

public interface IJIRAConnector {
	void login(String url, String projectName, String user, String password);
	void logout();

	List<JIRAIssue> findTasks(String query);
	List<JIRAComment> getComments(JIRAIssue jiraIssue);

	// FIXME: create real POJOs for those entities
	Map[] getProjects();
	Map getUser(String userName);
	Map[] getVersions();
	Map[] getComponents();
	
	void createJIRATask(JIRAIssue jiraIssue);
	void addComment(JIRAIssue jt, String comment);
	void closeIssue(JIRAIssue jiraIssue);
	
	List<String> getAttachmentsNames(JIRAIssue jiraIssue);
	void addAttachment(JIRAIssue jiraIssue,String fileName,byte[] data);
}