/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.JacobObject;
import com.jacob.com.MainSTA;
import com.jacob.com.ROT;

public abstract class ComThread {
    private static final int MTA = 0;
    private static final int STA = 2;
    public static boolean haveSTA = false;
    public static MainSTA mainSTA = null;

    static {
        System.loadLibrary("jacob");
    }

    public static synchronized void InitMTA() {
        ComThread.InitMTA(false);
    }

    public static synchronized void InitSTA() {
        ComThread.InitSTA(false);
    }

    public static synchronized void InitMTA(boolean createMainSTA) {
        ComThread.Init(createMainSTA, 0);
    }

    public static synchronized void InitSTA(boolean createMainSTA) {
        ComThread.Init(createMainSTA, 2);
    }

    public static synchronized void startMainSTA() {
        mainSTA = new MainSTA();
        haveSTA = true;
    }

    public static synchronized void quitMainSTA() {
        if (mainSTA != null) {
            mainSTA.quit();
        }
    }

    public static synchronized void Init(boolean createMainSTA, int mode) {
        if (createMainSTA && !haveSTA) {
            ComThread.startMainSTA();
        }
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ComThread: before Init: " + mode);
        }
        ComThread.doCoInitialize(mode);
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ComThread: after Init: " + mode);
        }
        ROT.addThread();
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ComThread: after ROT.addThread: " + mode);
        }
    }

    public static synchronized void Release() {
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ComThread: before clearObjects");
        }
        ROT.clearObjects();
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ComThread: before UnInit");
        }
        ComThread.doCoUninitialize();
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ComThread: after UnInit");
        }
    }

    public static synchronized void RemoveObject(JacobObject o) {
        ROT.removeObject(o);
    }

    public static native void doCoInitialize(int var0);

    public static native void doCoUninitialize();
}

